<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
class PurchaseInvoice extends CI_Controller{
	public function __construct() {

		parent::__construct();

		if($this->session->userdata('user_logged_in') != true) {
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		
		$this->load->library('form_validation');
		$this->load->helper('cookie','string');
		
	}
	function index($client="") {
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		
		$this->load->view('templates/header');
		$this->load->model('proforma_model');
		$data['results'] = $this->proforma_model->selectcount();
		
		$data['h']=$this->proforma_model->list_details($job_card_id);
		$data['detail']=$this->proforma_model->getonerow($job_card_id);
		$data['sumdetail']=$this->proforma_model->getsumrow($job_card_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('select'=>' - Select - '));
		$data['division_list'] = $list;
		$this->load->view('furniture/quotations/proforma_invoice_view',$data);
		$this->load->view('templates/footer');
		
		if(isset($_POST["invoice_save"])) {
			$this->load->model("proforma_model");
			$this->proforma_model->proforma_submit();
			$this->session->set_flashdata('response', 'Proforma Created...');
			redirect('proforma');
		}
		
		
	}

	function do_update($purchase_id,$pur_det_id='') {

		$data['total_other_expense'] = $this->Job_card_model->total_other_expense($purchase_id);
		$data['row']             = $this->Job_card_model->editPurchaseInvoiceRow($purchase_id);
		$data['details']         = $this->Job_card_model->editPurchaseInvoiceDetails($data['row']->purchase_h_id);

		if($pur_det_id!=''){
			$data['item']        = $this->Job_card_model->purchaseinvoiceitemwiseRow($pur_det_id);
		} else {
			$data['item']        =NULL;
		}
		
			//echo $pur_det_id;
			$purchase_no=$data['row']->purchase_no;

			$purchase_invoice_code=$data['row']->purchase_invoice_code;
			if(@$this->input->post('header_ledger_code')){
				$header_ledger_code = $this->input->post('header_ledger_code');
			} else {
				$header_ledger_code = NULL;
			}	
			$this->db->trans_begin();
			$user_id	=	$this->session->userdata('user_id');
			$purchase_date		   = date("Y-m-d", strtotime($this->input->post('purchase_date')));
			$data = array(
				'po_h_id'           => @$this->input->post('po_id'),
				'purchase_date'     => $purchase_date,
				'supplier_id'       => $this->input->post('supplier_id'),
				'loc_id'      		=> $this->input->post('loc_id'),
				'payment_mode'      => $this->input->post('payment_mode'),
				'supplier_inv_no' 	=> $this->input->post('supplier_inv_no'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'pi_ledger_code'    => $header_ledger_code,
			);
				
			$this->db->where('id', $purchase_id);
			$this->db->update('purchase_h', $data);
			
			$this->db->where("pur_h_id",$purchase_id);
			$this->db->delete('purchase_b');
		
			$loop_count	    =	count($this->input->post('list_p_description'));
			
				
			$p_description_id =	$this->input->post('list_p_description_id');
			$po_b_id	      =	$this->input->post('list_po_b_id');
			$p_description	  =	$this->input->post('list_p_description');
			$p_nbitem	      =	$this->input->post('list_p_nbitem');
			$description	  = $this->input->post('list_description');
			$uom	          = $this->input->post('list_uom');
			$p_section	      =	$this->input->post('list_p_section');
			$p_qty	          =	$this->input->post('list_p_qty');
			$p_rate	          =	$this->input->post('list_p_rate');
			$fx_rate	      =	$this->input->post('list_fx_rate');
			$p_discount	      =	$this->input->post('list_p_discount');
			$p_vat	       	  =	$this->input->post('list_p_vat');
			$p_ledger_code	  =	$this->input->post('list_p_ledger_code');
			$po_gross_amt     = 0;
			$po_discount      = 0;
			$po_vat_amt       = 0;
			$po_net_amt       = 0;
			for($i=0; $i<$loop_count; $i++){
				$chk_loop	    =	$p_description[$i];
				if($chk_loop!==''){
					$total2	=	(float)$p_qty[$i]*(float)$p_rate[$i]-(float)$p_discount[$i];

					if(@$p_section[$i] == ''){
					$p_section2 = '';
					} else {
					$p_section2 = $p_section[$i];
					}
					//echo $p_vat[$i]
					if($this->input->post('list_currency_id')!=1){ 
						$vat_amt = 0;
					} else {
						if(@$p_vat[$i] == ''){
							$vat_amt = 0;
						} else {
							$vat_amt = $p_vat[$i]/100;
						}
					}
					$p_description_idnbx= $p_description_id[$i];
					

					$data_array = array(
						'pur_h_id' 	        => $purchase_id,
						'pu_ledger_code' 	=> @$p_ledger_code[$i],
						'po_b_id' 	        => @$po_b_id[$i],
						'item_h_id'         => $p_description_idnbx,
						'item_name_purchase'=> $p_description[$i],
						'item_description'  => $description[$i],
						'item_qty' 		    => $p_qty[$i],
						'uom' 		        => $uom[$i],
						'item_fx_rate' 		=> $fx_rate[$i],
						'item_rate' 		=> $p_rate[$i],
						'item_disc_amt' 	=> $p_discount[$i],
						'item_amt' 		    => (($p_qty[$i]*$p_rate[$i])-(float)$p_discount[$i]),
						'item_vat_per' 		=> $vat_amt,
						'item_vat_amt' 		=> ($total2)*$vat_amt,
						'item_net_amt' 		=> ($total2)+(($total2)*$vat_amt),
						'technician'        => $p_section2
					);
					$this->db->insert('purchase_b', $data_array);	
				}
			}

			if($this->check_values_correct($purchase_id)){
				if($this->input->post('discount_bd')==='' && $this->input->post('round_off')===''){
					$this->furniture_quotation_model->update_purchase_invoice_total($purchase_id);
					$data = array(
						'status'      => 'Confirmed',
					);
					$where=array(
						'id'=> $purchase_id
					);
					$this->crud_model->update(' purchase_h',$data,$where );
				} else {
					$data = array(
						'status'      => 'Confirmed',
						'pur_discount'=> $this->input->post('discount_bd'),
						'pur_vat' 	  => $this->input->post('total_vat'),
						'sign' 	  	  => $this->input->post('sign'),
						'round_off'   => $this->input->post('round_off'),
						'pur_net_amt' => $this->input->post('grand_total'),
					);
		
					$where=array(
						'id'=> $purchase_id
					);
					$this->crud_model->update(' purchase_h',$data,$where );
				}
				
				

				$nbs='Yes';
				if($this->input->post('total_other_expense')!=''){
					$this->Job_card_model->update_other_expense_2($purchase_id,$nbs);
				}
				
				$this->Job_card_model->insert_into_item_trans($purchase_id);

				$log_data=array(
					'trans_no'     => $purchase_invoice_code,
					'trans_type'   => 'Purchase Invoice',
					'trans_op'     => 'Edit',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
				
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					redirect("furniture/PurchaseInvoice/listPurchaseInvoice");
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Success');			
					redirect("furniture/PurchaseInvoice/listPurchaseInvoice");
				}
			} else {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','the total amount does not match.',':old:');
				redirect("furniture/PurchaseInvoice/editPurchaseInvoice/".$purchase_id);
			}
	}

	function check_values_correct($purchase_id){
		$query = $this->db->query("SELECT `pur_det_id`,round((`item_qty`*`item_rate`)-`item_disc_amt`,3) as amount,round((`item_qty`*`item_rate`)-`item_disc_amt`,3)+`item_vat_amt` as line_total,`item_net_amt`,`item_vat_per`,`item_vat_amt` FROM `purchase_b` WHERE `pur_h_id` ='$purchase_id'");
		$itemList_date	=	$query->result_array();
		if($itemList_date!=false){
			$chk=0;
			$item_net_amt=0;
			$total_vat_disc =0;
			$total_vat =0;
			$xx =0;
			foreach($itemList_date as $row){
				if($row['line_total']!=$row['item_net_amt']){
					$chk++;
				} 
				$total_vat=$total_vat+$row['item_vat_amt'];
				if($this->input->post('discount_bd')!=''  AND $this->input->post('discount_bd')!='0'){
					$pur_det_id	= $row['pur_det_id'];
					$total_disc_na	=	$this->input->post('discount_bd')*($row['amount'])/$this->input->post('gross_amount');
					$dataw = array(
						'total_discount_item_wise'      => $total_disc_na
					);
		
					$wherew=array(
						'pur_det_id'=> $pur_det_id
					);
					$this->crud_model->update('purchase_b',$dataw,$wherew );

					$item_wise_vat	=	$total_disc_na*($row['item_vat_per']);

					$xx = $xx+($row['item_vat_amt']-($total_vat_disc +$item_wise_vat));
					$item_net_amt=$item_net_amt+$row['amount'];
				} else {
					$item_net_amt=$item_net_amt+$row['item_net_amt'];
				}
			}
			$total_amount=$item_net_amt;
			if($this->input->post('discount_bd')!=''  AND $this->input->post('discount_bd')!='0'){
				$total_amount	=	$item_net_amt-$this->input->post('discount_bd');
				$total_amount	=	$total_amount+$xx;
				$item_net_amt	=	$total_amount;
			}
			if($this->input->post('round_off')!=''  AND $this->input->post('round_off')!='0.000'){
				if($this->input->post('sign')==='-'){
					$total_amount	=	$item_net_amt-$this->input->post('round_off');
				} else {
					$total_amount	=	$item_net_amt+$this->input->post('round_off');
				}	 
			}
			if($this->input->post('grand_total')!=round($total_amount,3)){
				$chk++;
			}

			if($chk==0){
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	

	function editPurchaseInvoice($purchase_id,$pur_det_id='') {
		$this->form_validation->set_rules('purchase_date', 'Purchase Date', 'required');
		$this->form_validation->set_rules('loc_id', 'Location', 'required');
    	$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
		$this->session->keep_flashdata('response');
		if ($this->input->post('updateHeader')==='updateHeader') {
			$this->form_validation->set_rules('p_description[]', 'Product', 'required');
			$this->form_validation->set_rules('p_qty[]', 'Quantity', 'required');
			$this->form_validation->set_rules('uom[]', 'Unit', 'required');
			$this->form_validation->set_rules('p_rate[]', 'Rate', 'required');
			$this->form_validation->set_rules('p_vat[]', 'Vat %', 'required');
			$this->form_validation->set_rules('p_ledger_code[]', 'Ledger', 'required');
			
			if($this->input->post('payment_mode')==='Cash'){
				$this->form_validation->set_rules('header_ledger_code', 'Ledger', 'required');
			}
		}
		if($this->input->post('pi_type')==='Job'){
			$this->form_validation->set_rules('job_id', 'Job No', 'required');
		}
		if ($this->input->post('updateHeader2')==='Confirm') {
			$this->form_validation->set_rules('list_loc_id', 'Location', 'required');
			$this->form_validation->set_rules('list_p_ledger_code[]', 'Ledger', 'required');
		}

		$data['total_other_expense'] = $this->Job_card_model->total_other_expense($purchase_id);
		$data['row']             = $this->Job_card_model->editPurchaseInvoiceRow($purchase_id);
		$data['details']         = $this->Job_card_model->editPurchaseInvoiceDetails($data['row']->purchase_h_id);

		if($pur_det_id!=''){
			$data['item']        = $this->Job_card_model->purchaseinvoiceitemwiseRow($pur_det_id);
		} else {
			$data['item']        =NULL;
		}
		
		if ($this->form_validation->run() == FALSE){
			$this->load->view('templates/header');
			$data['currency']=$this->Job_card_model->currency();
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
			$data['division_list'] = $list;

			$list2 = $this->crud_model->location_list();
			$data['location_list'] = $list2;

			$data['purchaseNumber'] = $data['row']->purchase_invoice_code;

			if($this->furniture_quotation_model->config(1)){
				$config_data=$this->furniture_quotation_model->config(1);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}
	
			$qt_date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
	
			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;
			$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select Ledger - '), array('acoount_group_id' => 22));
			$data['header_ledger_list'] = $header_ledger_list;
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('furniture/quotations/purchaseinvoice/editPurchaseInvoice',$data);
			$this->load->view('templates/footer');
		} else {
			if ($this->input->post('updateHeader')==='updateHeader') {		
				$this->updateArea1($purchase_id,$pur_det_id='');
			} else if($this->input->post('updateHeader2')==='Confirm') {
				$this->do_update($purchase_id);
			}
		}
	}


	function updateArea1($purchase_id,$pur_det_id='') {

		$data['total_other_expense'] = $this->Job_card_model->total_other_expense($purchase_id);
		$data['row']             = $this->Job_card_model->editPurchaseInvoiceRow($purchase_id);
		$data['details']         = $this->Job_card_model->editPurchaseInvoiceDetails($data['row']->purchase_h_id);

		if($pur_det_id!=''){
			$data['item']        = $this->Job_card_model->purchaseinvoiceitemwiseRow($pur_det_id);
		} else {
			$data['item']        =NULL;
		}
		
			$purchase_no=$data['row']->purchase_no;
			$purchase_invoice_code=$data['row']->purchase_invoice_code;
			$this->db->trans_begin();
			$user_id	=	$this->session->userdata('user_id');
			if(@$this->input->post('header_ledger_code')!='') {
				$header_ledger_code = $this->input->post('header_ledger_code');
			} else {
				$header_ledger_code = NULL;
			}	
			$data = array(
				'po_h_id'           => @$this->input->post('po_id'),
				'purchase_no'       => $this->input->post('purchase_no'),
				'supplier_id'       => $this->input->post('supplier_id'),
				'loc_id'      		=> $this->input->post('loc_id'),
				'payment_mode'      => $this->input->post('payment_mode'),
				'supplier_inv_no' 	=> $this->input->post('supplier_inv_no'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'pi_ledger_code'    => $header_ledger_code,
				'user_id'           => $user_id,
				'status'            => 'Draft'
			);
				
			$this->db->where('id', $purchase_id);
			$this->db->update('purchase_h', $data);
			
			$update_data = array(
				'lcost' 		=> NULL,
				'tcost' 		=> NULL
			);
			$this->db->where('pur_h_id', $purchase_id);
			$this->db->update('purchase_b', $update_data);
				
			$loop_count	    =	count($this->input->post('p_description'));
			
				
			$p_description_id =	$this->input->post('p_description_id');
			$po_b_id	      =	$this->input->post('po_b_id');
			$p_description	  =	$this->input->post('p_description');
			$p_nbitem	      =	$this->input->post('p_nbitem');
			$description	  = $this->input->post('description');
			$uom	          = $this->input->post('uom');
			$p_section	      =	$this->input->post('p_section');
			$p_qty	          =	$this->input->post('p_qty');
			$p_rate	          =	$this->input->post('p_rate');
			$fx_rate	      =	$this->input->post('fx_rate');
			$p_discount	      =	$this->input->post('p_discount');
			$p_vat	       	  =	$this->input->post('p_vat');
			$p_ledger_code	  = $this->input->post('p_ledger_code');
			$po_gross_amt     = 0;
			$po_discount      = 0;
			$po_vat_amt       = 0;
			$po_net_amt       = 0;
			for($i=0; $i<$loop_count; $i++){
				/* if($this->input->post('togBtn')){
					$chk_loop =	$p_description[$i];
				} else {
					$chk_loop =	$p_description_id[$i];
				} */
				$chk_loop =	$p_description[$i];
				if($chk_loop!==''){
					$total2	=	(float)$p_qty[$i]*(float)$p_rate[$i]-(float)$p_discount[$i];
					if(@$p_section[$i] == ''){
					$p_section2 = '';
					} else {
					$p_section2 = $p_section[$i];
					}
					if($this->input->post('currency')!=1){ 
						$vat_amt = 0;
					} else {
						if(@$p_vat[$i] == ''){
							$vat_amt = 0;
						} else {
							$vat_amt = $p_vat[$i]/100;
						}
					}
					if(@$p_description_id[$i]===''){
						$p_description_idnbx= 0;
					} else {
						$p_description_idnbx= $p_description_id[$i];
					}

					$data_array = array(
						'pur_h_id' 	        => $purchase_id,
						'pu_ledger_code' 	=> $p_ledger_code[$i],
						'po_b_id' 	        => @$po_b_id[$i],
						'item_h_id'         => $p_description_idnbx,
						'item_name_purchase'=> $p_description[$i],
						'item_description'  => $description[$i],
						'item_qty' 		    => $p_qty[$i],
						'uom' 		        => $uom[$i],
						'item_fx_rate' 		=> $fx_rate[$i],
						'item_rate' 		=> $p_rate[$i],
						'item_disc_amt' 	=> $p_discount[$i],
						'item_amt' 		    => (($p_qty[$i]*$p_rate[$i])-(float)$p_discount[$i]),
						'item_vat_per' 		=> $vat_amt,
						'item_vat_amt' 		=> ($total2)*$vat_amt,
						'item_net_amt' 		=> ($total2)+(($total2)*$vat_amt),
						'technician'        => $p_section2
					);
					
					
					if($pur_det_id!=''){
						$wherex=array(
							'pur_det_id'=> $pur_det_id
						);
						$this->db->update('purchase_b', $data_array,$wherex);
					} else {
						$this->db->insert('purchase_b', $data_array);
					}
				}
			}
			
			$this->furniture_quotation_model->update_purchase_invoice_total($purchase_id);
			$this->db->where("trans_no",$purchase_invoice_code);
			$this->db->where("trans_type",'1');
			$this->db->delete('item_trans');

			$this->db->where("vch_no",$purchase_invoice_code);
			$this->db->where("vch_type",'PURCHASE');
			$this->db->delete('accounts');

			$this->db->where("trn_no",$purchase_invoice_code);
			$this->db->where("trn_type",'Purchase Invoice');
			$this->db->delete('supplier_bill_allocations');

			$this->db->where("vch_no",$purchase_invoice_code);
			$this->db->where("vch_type",'Purchase Invoice');
			$this->db->delete('job_allocation');

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseInvoice/listPurchaseInvoice");
			} else {
				$this->db->trans_commit();
				if($pur_det_id!=''){
					$this->session->set_flashdata('success', 'Updated Successfully');
				} else {
					$this->session->set_flashdata('success', 'Added Successfully');
				}			
				redirect("furniture/PurchaseInvoice/editPurchaseInvoice/".$purchase_id);
			}
		
	}

	public function listPurchaseInvoice(){
		//	$this->OppLogin->permission("PurchaseOrder", "View");
		$title['headerTitle']="Purchase Invoice";
		$this->data['listDatas'] = $this->Job_card_model->get_all_purchase_invoice();
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/purchaseinvoice/listPurchaseInvoice',$this->data);
		$this->load->view('templates/footer');
	}

	public function printPurchaseInvoice($purchase_id){
		$datas['row']	= $this->Job_card_model->purchaseInvoiceRow($purchase_id);
		$division_id	=	$datas['row']->division_id;
		
		
		$this->db->select('*' );
		$this->db->from('company_division');
		$this->db->where('division_id', $division_id);
		$rs = $this->db->get();
		$datas['logo_filename'] = $rs->row()->logo_filename;

		$datas['details']= $this->Job_card_model->purchaseInvoiceDetailsXX($purchase_id);
	
		$query = $this->db->get('company_details');  
		$datas['company_details'] = $query->row();

		$this->load->view('furniture/quotations/purchaseinvoice/printPurchaseInvoice',$datas);
	}

	public function printtest($purchase_id){
		$datas['row']	 = $this->Job_card_model->purchaseInvoiceRow($purchase_id);
		$datas['details']= $this->Job_card_model->purchaseInvoiceDetailsXX($purchase_id);
		$title['headerTitle']="Purchase Invoice";
		$purchase_invoice_code	=	$datas['row']->purchase_invoice_code;

		$query3 = $this->db->query("SELECT IT.trans_no,IT.item_id,IT.item_qty,IT.item_rate,IT.item_amount,T.item_name FROM `item_trans` IT  INNER JOIN `items` T ON T.id=IT.item_id  WHERE  IT.`trans_no`='$purchase_invoice_code' AND IT.`trans_type`='1'");
		$datas['item_trans']	=	$query3->result_array();

		$query4 = $this->db->query("SELECT A.vch_type,A.vch_no,A.ledger_code,A.ledger_amount,L.ledger_name FROM `accounts` A INNER JOIN `ledgers` L ON L.ledger_code=A.ledger_code WHERE A.`vch_no`='$purchase_invoice_code'  AND A.vch_type='PURCHASE' order by id ");
		$datas['account_trans']	=	$query4->result_array();

		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/purchaseinvoice/printtest',$datas);
		$this->load->view('templates/footer');
	}
	

	public function expense_distribute($id){
		if($id!=''){
			$nbs='No';
			if($this->input->post('total_other_expense')!='0.000'){
				$this->Job_card_model->update_other_expense_2($id,$nbs);
			}
			redirect("furniture/PurchaseInvoice/editPurchaseInvoice/".$id);
		} else {
			redirect("furniture/PurchaseInvoice/listPurchaseInvoice");
		}
	}
	public function other_expense($id){
		$this->form_validation->set_rules('amount[]', 'Amount', 'required');
		$purchase_expense=$this->Job_card_model->purchase_expense();
		$payabel=$this->Job_card_model->payabel();
		$other_expenseData=$this->Job_card_model->other_expenseData($id);
		$dbdata      = $this->Job_card_model->editPurchaseInvoiceRow($id);
		$list2 = $this->crud_model->get_list('loc_id','loc_name','location_master',array(''=>' - Select Location - '));
		$currency=$this->Job_card_model->currency();
		$datas   =   array("id" => $id,"purchase_expense" => $purchase_expense,"payabel" => $payabel,"other_expenseData" => $other_expenseData,"dbdata" => $dbdata,"location_list" => $list2,"currency" => $currency);
		//$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
    	//$this->form_validation->set_rules('payment_mode', 'Payment Mode', 'required');
        if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/purchaseinvoice/other_expense',$datas);
			$this->load->view('templates/footer');
        } else {
			$purchase_expense =	$this->input->post('purchase_expense');
			$payable	      =	$this->input->post('payable');
			$amount	          =	$this->input->post('amount');
			//$this->db->where('purchase_id', $id);
			//$this->db->delete('purchase_invoice_other_expense');
			$update_data = array(
				'lcost' 		=> NULL,
				'tcost' 		=> NULL
			);
			$this->db->where('pur_h_id', $id);
			$this->db->update('purchase_b', $update_data);
			
			for($i=0; $i<count($purchase_expense); $i++){
				if($purchase_expense[$i]!==''){
					$data_array = array(
						'purchase_id' 	     => $id,
						'purchase_expense_id'=> $purchase_expense[$i],
						'payable_id' 		 => $payable[$i],
						'amount' 		     => $amount[$i],
						'created_date'       => date("Y-m-d"),
						'status'             => 1
					);
					$this->db->insert('purchase_invoice_other_expense', $data_array);
	  			}
			}
			
			$this->session->set_flashdata('msg','Created Successfully');
		  	redirect("furniture/PurchaseInvoice/other_expense/".$id);
		}
	}

	public function search_items() {
		$item	=	$this->input->post('item');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$query3 = $this->db->query("SELECT * FROM `items`  WHERE `status`='1' and `is_purchase`='1' and `item_name` like '%$item%'");
		$itemList_date	=	$query3->result_array();
		$itemList='';
		foreach($itemList_date as $itemList_datas){
			$html.='<li class="search_item_list p_description_button" data-rate="'.$itemList_datas['selling_price'].'"  data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" data-item_cost="'.$itemList_datas['selling_price'].'" data-item_details_id="'.$itemList_datas['id'].'" data-uom="'.$itemList_datas['unit'].'" item_tax_rate="5">'.$itemList_datas['item_name'].'</li>';
		}
		if(count($itemList_date)==0){
			$html.='<li>No data found</li>';
		}
		print $html;
	}

	public function do_insert() {
		$this->form_validation->set_rules('purchase_date', 'Purchase Date', 'required');
		$this->form_validation->set_rules('loc_id', 'Location', 'required');
    	$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
		if($this->input->post('po_id')!=''){
			$this->form_validation->set_rules('p_description[]', 'Product', 'required');
		}
		if($this->input->post('payment_mode')==='Cash'){
			$this->form_validation->set_rules('header_ledger_code', 'Ledger', 'required');
		}
		$this->form_validation->set_rules('pi_type', 'Type', 'required');
		if($this->input->post('pi_type')==='Job'){
			$this->form_validation->set_rules('job_id', 'Job No', 'required');
		}
		if($this->input->post('po_id')===''){
			$this->form_validation->set_rules('list_p_ledger_code[]', 'Ledger', 'required');
		} else {
			$this->form_validation->set_rules('p_ledger_code[]', 'Ledger', 'required');
		}
		
		/*if($this->input->post('po_id')===''){
			if($this->input->post('togBtn')){
				$this->form_validation->set_rules('p_description[]', 'Product', 'required');
			} else {
				$this->form_validation->set_rules('p_description_id[]', 'Product', 'required');
			}
		}*/
		
        if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseInvoice/create_purchase_invoice');
        } else {
			$this->db->trans_begin();
	  		$user_id	=	$this->session->userdata('user_id');
			$purchase_date		   = date("Y-m-d", strtotime($this->input->post('purchase_date')));
	 		$purchaseInvoiceNumber = $this->Job_card_model->purchaseInvoiceNumber($this->input->post('division'));
			$purchase_invoice_code = $this->Job_card_model->get_purchase_invoice_no($purchaseInvoiceNumber,$this->input->post('division'));
			$data = array( 
				'po_h_id'         		=> $this->input->post('po_id'),
			  	'purchase_no'         	=> $purchaseInvoiceNumber,
				'purchase_invoice_code' => $purchase_invoice_code,
				'purchase_date'         => $purchase_date,
				'supplier_id'       	=> $this->input->post('supplier_id'),
				'division_id'       	=> $this->input->post('division'),
				'supplier_reference'	=> $this->input->post('supplier_ref'),
				'job_id'            	=> $this->input->post('job_id'),
				'loc_id'      			=> $this->input->post('loc_id'),
				'currency_id'           => $this->input->post('currency'),
				'payment_mode'      	=> $this->input->post('payment_mode'),
				'delivery_address'  	=> $this->input->post('supply_address'),
				'delivery_terms'    	=> $this->input->post('delivery_terms'),
				'pi_type'    			=> $this->input->post('pi_type'),
				'pi_ledger_code'    	=> @$this->input->post('header_ledger_code'),
				'user_id'           	=> $user_id,
				'status'            	=> 'Draft'
			);
			$this->db->insert('purchase_h', $data);
			$insert_id = $this->db->insert_id();
	  		if($insert_id){
				/*if($this->input->post('po_id')===''){
					if($this->input->post('togBtn')){
						$loop_count	  =	count($this->input->post('p_description'));
					} else {
						$loop_count	  =	count($this->input->post('p_description_id'));
						
					}
				} else {*/
					if($this->input->post('po_id')===''){
						$loop_count	 	  =	count($this->input->post('list_p_description'));
						$p_description_id =	$this->input->post('list_p_description_id');
						$p_description	  =	$this->input->post('list_p_description');
						$description	  = $this->input->post('list_description');
						$p_nbitem	      =	$this->input->post('list_p_nbitem');
						$p_section	      =	$this->input->post('list_p_section');
						$p_qty	          =	$this->input->post('list_p_qty');
						$uom	          = $this->input->post('list_uom');
						$p_rate	          =	$this->input->post('list_p_rate');
						$p_discount	      =	$this->input->post('list_p_discount');
						$p_vat	          =	$this->input->post('list_p_vat');
						$fx_rate	      =	$this->input->post('list_fx_rate');
						$po_b_id	      =	@$this->input->post('list_po_b_id');
						$p_ledger_code	  = $this->input->post('list_p_ledger_code');
					} else {
						$loop_count	 	  =	count($this->input->post('p_description'));
						$p_description_id =	$this->input->post('p_description_id');
						$p_description	  =	$this->input->post('p_description');
						$description	  = $this->input->post('description');
						$p_nbitem	      =	$this->input->post('p_nbitem');
						$p_section	      =	$this->input->post('p_section');
						$p_qty	          =	$this->input->post('p_qty');
						$uom	          = $this->input->post('uom');
						$p_rate	          =	$this->input->post('p_rate');
						$p_discount	      =	$this->input->post('p_discount');
						$p_vat	          =	$this->input->post('p_vat');
						$fx_rate	      =	$this->input->post('fx_rate');
						$po_b_id	      =	@$this->input->post('po_b_id');
						$p_ledger_code	  = $this->input->post('p_ledger_code');
					}
				//}
				
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				for($i=0; $i<$loop_count; $i++){
					/*if($this->input->post('po_id')===''){
						if($this->input->post('togBtn')){
							$chk_loop =	$p_description[$i];
						} else {
							$chk_loop =	$p_description_id[$i];
						}
					} else {*/
						$chk_loop =	$p_description[$i];
					//}
					if($chk_loop!==''){
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
						
						if($this->input->post('currency')!=1){ 
							$vat_amt = 0;
						} else {
							if(@$p_vat[$i] == ''){
								$vat_amt = 0;
							} else {
								$vat_amt = $p_vat[$i]/100;
							}
						}
						if(@$p_description_id[$i]===''){
							$p_description_idnbx = 0;
						} else {
							$p_description_idnbx = $p_description_id[$i];
							//$this->Job_card_model->insert_item_trans_data($purchase_invoice_code,$p_description_id[$i],date("Y-m-d"),1,$p_qty[$i],$this->input->post('loc_id'),$p_rate[$i],$total2);
						}
						if($this->input->post('po_id')!=''){
							if($p_description_id[$i]!='0'){
								//$this->Job_card_model->insert_item_trans_data($purchase_invoice_code,$p_description_id[$i],date("Y-m-d"),1,$p_qty[$i],$this->input->post('loc_id'),$p_rate[$i],$total2);
							}
						}
						
						$data_array = array(
							'pur_h_id' 	        => $insert_id,
							'pu_ledger_code' 	=> $p_ledger_code[$i],
							'item_h_id'  		=> $p_description_idnbx,
							'uom'  				=> $uom[$i],
							'po_b_id'  			=> @$po_b_id[$i],
							'item_name_purchase'=> $p_description[$i],
			  				'item_description'  => $description[$i],
							'loc_id' 	  		=> $this->input->post('loc_id'),
							'item_qty' 		    => $p_qty[$i],
							'item_fx_rate' 		=> $fx_rate[$i],
			  				'item_rate' 		=> $p_rate[$i],
			 				'item_disc_amt'  	=> $p_discount[$i],
							'item_amt' 		    => (($p_qty[$i]*$p_rate[$i])-(float)$p_discount[$i]),
							'item_vat_per' 		=> $vat_amt,
							'item_vat_amt' 		=> ($total2)*$vat_amt,
							'item_net_amt' 		=> ($total2)+(($total2)*$vat_amt),
							'status'            => 1
						);
						$this->db->insert('purchase_b', $data_array);
					}	
				}
				$this->furniture_quotation_model->update_purchase_invoice_total($insert_id);
				$log_data=array(
					'trans_no'     => $purchase_invoice_code,
					'trans_type'   => 'Purchase Invoice',
					'trans_op'     => 'Create',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
	  		}
			if($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseInvoice/listPurchaseInvoice");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Purchase Invoice Created Successfully');
				redirect("furniture/PurchaseInvoice/editPurchaseInvoice/".$insert_id);
			}
		}
	}

	public function do_update_discount($po_id) {
		$this->form_validation->set_rules('nb_purchase_h_id', 'Purchase ID', 'required');
		if ($this->form_validation->run() == FALSE)	{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseInvoice/editPurchaseInvoice/'.$po_id);
		} else {
			$this->db->trans_begin();
			$total_other_expense = $this->input->post('total_other_expense');
			$data = array(
				'pur_discount'=> $this->input->post('discount_bd'),
				'pur_vat' 	  => $this->input->post('total_vat'),
				'sign' 	  	  => $this->input->post('sign'),
				'round_off'   => $this->input->post('round_off'),
				'pur_net_amt' => $this->input->post('grand_total'),
			);

			$where=array(
				'id'=> $po_id
			);
			$this->crud_model->update(' purchase_h',$data,$where );

			if($total_other_expense!=''){
				$this->Job_card_model->update_other_expense($po_id);
			}

			$data2 = array(
				'job_id' 	 => $this->input->post('mar_job_id'),
			);
			//$this->crud_model->update(' purchase_b',$data2,$where );
			$page=1;
			
			if($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect('furniture/PurchaseInvoice/editPurchaseInvoice/'.$po_id);
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Updated Successfully');
				redirect('furniture/PurchaseInvoice/editPurchaseInvoice/'.$po_id);
			}
		}
	}

	public function search_ledger() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		
		$like=array('ledger_name'=>$client);
		$where=" status=1 and (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=19 and acoount_group_id!=20) ";
		$client_contact_data=$this->crud_model->get('ledgers',$where,25,0,null,null,$like,null,null);
		//$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=19 and acoount_group_id!=20 ) and `ledger_name` like '%$client%'   order by ledger_name limit 25 ");
		$n=1;
		if(count($client_contact_data)>0){
			$html ='';
			foreach ($client_contact_data as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['ledger_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	public function searchSupplier() {
		$client	=	$this->input->post('client');
		$client_contact_data = $this->db->query("SELECT * FROM `supplier_master` WHERE `supplier_name` LIKE  '%$client%'");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
					$html.='<li value="' .$client_contact_datas['supplier_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['supplier_name'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['address'].'" />'.$client_contact_datas['supplier_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function searchPurchaseOrder() {
		$po_number = $this->input->post('po_number');
		$division = $this->input->post('division');
		//print 'aaa';
		$jobDatas = $this->Job_card_model->getAllPurchaseOrder($division,$po_number);
		if($jobDatas!=false){
			$n=1;
			$html ='';
			foreach ($jobDatas as $jobData){
				$html.='<li value="' .$jobData['po_id'].'" class="purchase_order_button" tabindex="'.$n++.'" ><input type="hidden" class="po_code" value="'.$jobData['po_code'].'" /><input type="hidden" class="division_id" value="'.$jobData['division_id'].'" /><input type="hidden" class="supplier_name" value="'.$jobData['supplier_name'].'" /><input type="hidden" class="supplier_id" value="'.$jobData['supplier_id'].'" /><input type="hidden" class="supplier_reference" value="'.$jobData['supplier_reference'].'" /><input type="hidden" class="po_type" value="'.$jobData['po_type'].'" /><input type="hidden" class="delivery_address" value="'.$jobData['delivery_address'].'" /><input type="hidden" class="delivery_terms" value="'.preg_replace("/#?[a-z0-9]+;/i","",$jobData['delivery_terms']).'" /><input type="hidden" class="job_card_number" value="'.$jobData['job_card_number'].'" /><input type="hidden" class="job_id" value="'.$jobData['id'].'" /><input type="hidden" class="client_name" value="'.$jobData['client_name'].'" /><input type="hidden" class="client_telephone1" value="'.$jobData['client_telephone1'].'" /><input type="hidden" class="currency_id" value="'.$jobData['currency_id'].'" /><input type="hidden" class="poh_ledger_code" value="'.$jobData['poh_ledger_code'].'" />'.$jobData['po_code'].'</li>';
			}
			header('Content-type: Application/json');
			echo json_encode($html, JSON_UNESCAPED_SLASHES);
		}else{
			$html='<li style="color:red;" class="purchase_order_button" > No Results Found </li>';
			header('Content-type: Application/json');
			echo json_encode($html, JSON_UNESCAPED_SLASHES);
		}
	}
	public function getPurchaseDetailedList() {
		$po_id = $this->input->post('po_id');
		//$division_id = $this->input->post('division_id');
		$purchaseDetailedData = $this->Job_card_model->purchaseInvoiceDetails($po_id);
		//$technician      = $this->ServicesModel->technician();
		if($purchaseDetailedData!=false){
			$list = '';
		  	/*$list = '<div class="row " ><div class="form-group col-md-3 mb-0">
			  <label class="form-label">Description</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label qty">Qty</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Unit</label>
			  
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">FxRate</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Rate</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Discount</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Amount</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Vat%</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Vat</label>
		  </div>
		  <div class="col-md-12 col-xl-1">
			  <label class="form-label">Net Amount</label>
		  </div>
		  </div>';*/
		  $k=1;
		  	foreach($purchaseDetailedData AS $purchaseDetailed){
				$invoice_qty = $this->Job_card_model->checkQuantity($purchaseDetailed['po_b_id']);
				$remaining_qty = $purchaseDetailed['item_qty']-$invoice_qty;
					if($remaining_qty>0){
			  			$item_price1 = $remaining_qty*$purchaseDetailed['item_rate'];
			  			$p_vat_amount = $purchaseDetailed['item_vat_per']*$item_price1;
			  			$net_amount = $item_price1+$p_vat_amount;
			  		if($purchaseDetailed['item_details_id']==0){
						$item_name=$purchaseDetailed['item_name_nbs'];
			  		} else {
						$item_name=$purchaseDetailed['item_name'];
					}

					$po_ledger_code	=	$purchaseDetailed['po_ledger_code'];
					if($po_ledger_code!=''){
						$where = array('ledger_code' => $po_ledger_code);
						$this->db->where($where);
						$this->db->select('*' );
						$this->db->from('ledgers');
						$rs = $this->db->get();
						if($rs->num_rows() > 0){
							$po_ledger=$rs->result_array()[0]['ledger_name'];
						}else{
							$po_ledger='Purchase';
						}
					} else {
						$po_ledger_code='P0001';
						$po_ledger='Purchase';
					}
				
					$list .= '<tr class="rowDiv2">';
					$list .= '<td class="nbcount">'.$k++.'</td>';
					$list .= '<td class=""><input type="hidden" id="po_b_id" class="form-control" name="po_b_id[]" value="'.$purchaseDetailed['po_b_id'].'" />';
					$list .= '<input type="hidden" class="form-control p_description" id="p_description" name="p_description[]"  value="'.$item_name.'"  autocomplete="off" ><input  type="hidden" name="p_description_id[]" class="input-percentage p_description_id" value="'.$purchaseDetailed['item_details_id'].'" autocomplete="off"/>'.$item_name.'</td>';
					$list .= '<td style="width: 100px;padding: 0;margin: 0;"><input  type="hidden" name="description[]" class="input-percentage description" value="'.$purchaseDetailed['body_description'].'" autocomplete="off"/><input type="text" class="form-control p_qty numbersOnly" id="p_qty" name="p_qty[]" value="'.$remaining_qty.'" autocomplete="off" ><input type="hidden" class="form-control hidden_p_qty numbersOnly" id="hidden_p_qty" name="hidden_p_qty[]" value="'.$remaining_qty.'" autocomplete="off"></td>';
					$list .= '<td style="text-align:left;"><input type="hidden" class="form-control uom numbersOnly" id="uom" name="uom[]" value="'.$purchaseDetailed['uom'].'" autocomplete="off">'.$purchaseDetailed['uom'].'</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="form-control fx_rate numbersOnly" id="fx_rate" name="fx_rate[]" value="'.$purchaseDetailed['item_fx_rate'].'" autocomplete="off">'.$purchaseDetailed['item_fx_rate'].'</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="form-control p_rate numbersOnly" id="p_rate" name="p_rate[]" value="'.$purchaseDetailed['item_rate'].'" autocomplete="off" readonly>'.$purchaseDetailed['item_rate'].'</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="form-control p_discount numbersOnly" id="p_discount" name="p_discount[]" value="'.$purchaseDetailed['item_disc'].'" autocomplete="off" readonly>'.$purchaseDetailed['item_disc'].'</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="form-control p_amount numbersOnly" id="p_amount" name="p_amount[]" value="'.$purchaseDetailed['item_amount'].'" autocomplete="off">'.$purchaseDetailed['item_amount'].'</td>';
					$list .= '<td style="text-align:right;">&nbsp;</td>';
					$list .= '<td style="text-align:right;">&nbsp;</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="p_vat" name="p_vat[]" value="'.($purchaseDetailed['item_vat_per']*100).'" autocomplete="off">'.($purchaseDetailed['item_vat_per']*100).'</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="form-control p_vat_amount numbersOnly" id="p_vat_amount" name="p_vat_amount[]"  value="'.$purchaseDetailed['item_vat'].'" autocomplete="off">'.$purchaseDetailed['item_vat'].'</td>';
					$list .= '<td style="text-align:right;"><input type="hidden" class="form-control p_net_amount numbersOnly" id="p_net_amount"  name="p_net_amount[]" value="'.$purchaseDetailed['net_amount'].'" autocomplete="off">'.$purchaseDetailed['net_amount'].'</td>';
					$list .= '<td style="text-align:left;width: 150px;padding: 0;margin: 0;">';
					$list .= '<input type="text" class="form-control p_ledger" id="p_ledger" name="p_ledger[]" autocomplete="off" value="'.$po_ledger.'">';
					$list .= '<input type="hidden" class="form-control p_ledger_code" id="p_ledger_code"  name="p_ledger_code[]" value="'.$po_ledger_code.'" autocomplete="off">';
					$list .= '<div class="ledger_result">';
					$list .= '<ul class="ledgerList unstyled">';
					$list .= '</ul>';
					$list .= '</div>';
					$list .= '</td>';
					$list .= '<td style="text-align:left;"> &nbsp; &nbsp;<a class="minus deleteRow" data-bs-target=".bd-example-modal-lg " ><i class="fa fa-trash"></i></a></td>';
					$list .= '</tr>';  
				}
			}
		} else {
		  $list = '<tr><td colspan="11">No List</td></tr>';
		}
		echo $list;
	}

	function create_purchase_invoice($client="") {
		$title['headerTitle']="Purchase Invoice Create";
		$this->load->view('templates/header',$title);
		$data['currency']=$this->Job_card_model->currency();
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->location_list();
		$data['location_list'] = $list2;

		$nn=$this->Job_card_model->purchaseInvoiceNumber(1);
		$data['purchaseNumber'] = $this->Job_card_model->get_purchase_invoice_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=date("Y-m-d");
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select Ledger - '), array('acoount_group_id' => 22));
		$data['header_ledger_list'] = $header_ledger_list;
		$this->load->view('furniture/quotations/purchaseinvoice/create_purchase_invoice',$data);
		$this->load->view('templates/footer');
	}
	public function pi_item_delete($pur_det_id,$purchase_h_id,$purchase_invoice_code,$item_id,$supplier_code){
		$this->db->where("pur_det_id",$pur_det_id);
		$this->db->delete('purchase_b');
		$this->furniture_quotation_model->update_purchase_invoice_total($purchase_h_id);
		$update_data = array(
			'lcost' 		=> NULL,
			'tcost' 		=> NULL
		);
		$this->db->where('pur_h_id', $purchase_h_id);
		$this->db->update('purchase_b', $update_data);

		$this->db->where("trans_no",$purchase_invoice_code);
		$this->db->where("trans_type",'1');
		$this->db->delete('item_trans');

		$this->db->where("vch_no",$purchase_invoice_code);
		$this->db->where("vch_type",'PURCHASE');
		$this->db->delete('accounts');

		$this->db->where("trn_no",$purchase_invoice_code);
		$this->db->where("trn_type",'Purchase Invoice');
		$this->db->delete('supplier_bill_allocations');

		$this->db->where("vch_no",$purchase_invoice_code);
		$this->db->where("vch_type",'Purchase Invoice');
		$this->db->delete('job_allocation');

		$query = $this->db->query("select item_rate,trans_date from item_trans where item_id='$item_id' order by item_trans_id desc limit 1");
		if($query->result_array()!=false){
			echo 'Yes';
			$item_rate = $query->row()->item_rate;
			$trans_date = $query->row()->trans_date;
			$item_data = array(
				'last_purchase_rate' 	=> $item_rate,
				'last_purchase_date' 	=> $trans_date,
				'last_purchase_supplier'=> $supplier_code,
			);
			$this->db->where('id', $item_id);
			$this->db->update('items', $item_data);
		} else {
			$item_data = array(
				'last_purchase_rate' 	=> NULL,
				'last_purchase_date' 	=> NULL,
				'last_purchase_supplier'=> '0',
			);
			$this->db->where('id', $item_id);
			$this->db->where('last_purchase_supplier!=', '0');
			$this->db->update('items', $item_data);
		}

		$this->session->set_flashdata('response', 'Deleted...');
		redirect('furniture/PurchaseInvoice/editPurchaseInvoice/'.$purchase_h_id);
	}
	public function pi_expense_delete($pur_id,$other_expense_id){
		$this->db->where("id",$other_expense_id);
		$this->db->delete('purchase_invoice_other_expense');
		$update_data = array(
			'lcost' 		=> NULL,
			'tcost' 		=> NULL
		);
		$this->db->where('pur_h_id', $pur_id);
		$this->db->update('purchase_b', $update_data);
		$this->session->set_flashdata('response', 'Deleted...');
		redirect('furniture/PurchaseInvoice/other_expense/'.$pur_id);
	}

	public function cancel_pi($id,$purchase_invoice_code){
		$this->db->where('id',$id);
		$data = array(
			'status' => 'Cancel',
			'pur_cancelledby' => $this->session->userdata('user_name'),
			'pur_cancelled_date' => date('Y-m-d h:m:s')
		);
		$receipt_cancel	= $this->db->update('purchase_h', $data);
		
		$this->db->where('vch_type','PURCHASE');
		$this->db->where('vch_no',$purchase_invoice_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('accounts', $data1);

		$this->db->where('bill_id',$id);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('supplier_bill_allocations', $data1);

		$this->db->where('trans_type','1');
		$this->db->where('trans_no',$purchase_invoice_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('item_trans', $data1);

		$this->db->where("vch_no",$purchase_invoice_code);
		$this->db->where("vch_type",'Purchase Invoice');
		$this->db->update('job_allocation', $data1);
		
		$log_data=array(
			'trans_no'  	=>  $purchase_invoice_code,
			'trans_type'  	=>  'PURCHASE INVOICE',
			'trans_op'  	=>  'Cancel',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		if($receipt_cancel){
			$this->session->set_flashdata('response', 'Purchase Invoice Cancelled...');
		}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('furniture/PurchaseInvoice/listPurchaseInvoice');
	}

} 
?>